define([
    'marionette',
    'modules/appointments/appointments-radio',
],
function (Marionette, radio) {
    'use strict';

    /* extending view must have template, region.appointmentsListRegion */
    return Marionette.View.extend({
        // template
        // regions: { appointmentsListRegion }
        /* call _initializeSectionView in onRender */
        _initializeSectionView: function(options) {
            this.NoAppointmentsView = Marionette.View.extend({template: options.noAppointmentsTemplate});
            this.AppointmentsListView = options.AppointmentsListView;
        },
        _destroySectionView: function() {
            radio.off(null, null, this);
            delete this.NoAppointmentsView;
            delete this.AppointmentsListView;
        },
        onDestroy: function() {
            this._destroySectionView();
        },
        showAppointmentsView: function(options) {
            var appointmentsListRegion = this.getRegion('appointmentsListRegion');
            var view;
            var data = this.collection;
            if ((options || {}).collection) {
                data = options.collection;
            }

            if (!this.isDestroyed()) {
                if (this.collection.length > 0) {
                    view = new this.AppointmentsListView({collection: data});
                } else {
                    view = new this.NoAppointmentsView();
                }

                appointmentsListRegion.show(view);
            }
        },
        // filterAppointments
    });
});
